<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\Payment;

use CpCreation\VitiCore\Cart\Model\Payment\Etransactions;
use CpCreation\VitiCore\Cart\Model\Payment\Monetico;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\DataTransformerInterface;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;
use Symfony\Component\Serializer\Serializer;

class MoneticoPaymentType extends AbstractType implements PaymentMethodInterface, DataTransformerInterface
{
    const TYPE = 'monetico';

    private $serializer;

    public function __construct()
    {
        $normalizers = [new ObjectNormalizer()];
        $this->serializer = new Serializer($normalizers);
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class,[
                'label' => 'Nom',
                'required'    => true
            ])
            ->add('production', ChoiceType::class, [
                'choices' => [
                    'production' => true,
                    'test' => false,
                ],
                'label'       => 'Production',
                'required'    => true
            ])
            ->add('hmacKey', TextType::class, [
                'label'       => 'Clef Hmac',
                'required'    => true
            ])
            ->add('eptNumber', TextType::class, [
                'label'       => 'Tpe',
                'required'    => true
            ])
            ->add('companyCode', TextType::class, [
                'label'       => 'Code site',
                'required'    => true
            ])
        ;

        $builder->addModelTransformer($this);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Monetico::class
        ]);
    }

    public function transform($data)
    {

        return $this->serializer->denormalize($data, Monetico::class);
    }

    public function reverseTransform($data)
    {

        return $this->serializer->normalize($data);
    }

    public function getMethod()
    {
        return static::TYPE;
    }

    public function getBlockPrefix()
    {
        return 'monetico_payment';
    }
}