<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\Payment;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\TrumbowygType;
use CpCreation\VitiCore\Cart\Model\Payment\Check;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\DataTransformerInterface;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;
use Symfony\Component\Serializer\Serializer;

class BankTransfertPaymentType extends AbstractType implements PaymentMethodInterface, DataTransformerInterface
{
    const TYPE = 'banktransfert';

    private $serializer;

    public function __construct()
    {
        $normalizers = [new ObjectNormalizer()];
        $this->serializer = new Serializer($normalizers);
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class,[
                'label' => 'nom',
                'required'    => true
            ])
            ->add('text', TrumbowygType::class, [
                'label'       => 'Informations',
                'required'    => true
            ]);

        $builder->addModelTransformer($this);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Check::class
        ]);
    }

    public function transform($data)
    {

        return $this->serializer->denormalize($data, Check::class);
    }

    public function reverseTransform($data)
    {

        return $this->serializer->normalize($data);
    }

    public function getMethod()
    {
        return static::TYPE;
    }

    public function getBlockPrefix()
    {
        return 'banktransfert_payment';
    }
}
