<?php

namespace  CpCreation\VitiCore\Bridge\Symfony\Bundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritDoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder('cp_creation_viti_core');
        $rootNode = $treeBuilder->getRootNode();
        // Here you should define the parameters that are allowed to
        // configure your bundle. See the documentation linked above for
        // more information on that topic.
        $rootNode
            ->children()
                ->arrayNode('payment_method')
                    ->scalarPrototype()->end()
                ->end()
                ->arrayNode('social_network')
                    ->scalarPrototype()->end()
                ->end()
                ->arrayNode('return_path')
                    ->prototype('array')
                        ->children()
                            ->scalarNode('name')->end()
                            ->scalarNode('path')->end()
                            ->scalarNode('done')->defaultValue('payment_cb_return')->end()
                            ->scalarNode('refused')->defaultValue('payment_cb_return')->end()
                            ->scalarNode('canceled')->defaultValue('payment_cb_return')->end()
                            ->scalarNode('response_at')->defaultValue('etransactions_responseAt')->end()
                        ->end()
                    ->end()
                ->end()
                ->arrayNode('carriers')
                    ->scalarPrototype()->end()
                ->end()
                ->arrayNode('cb_directory_paths')
                    ->scalarPrototype()->end()
                ->end()
                ->scalarNode('maintenance_email')->defaultValue('web@cpcreation.fr')->end()
            ->end()
        ;
        return $treeBuilder;
    }
}
