<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Site;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Site\PaymentType;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Manager\PaymentProviderManager;
use CpCreation\VitiCore\Cart\Repository\PaymentMethodRepository;
use CpCreation\VitiCore\Contact\Repository\ContactRepository;
use CpCreation\VitiCore\Payment\Model\Payment;
use CpCreation\VitiCore\Payment\Repository\PaymentRepository;
use CpCreation\VitiCore\Shop\Model\ShopConfig;
use CpCreation\VitiCore\Shop\Repository\ShopConfigRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class PaymentController
 * @package CpCreation\SkeletonBundle\Controller
 */
class PaymentController extends AbstractController
{
    private $paymentRepository;
    private $paymentProviderManager;
    private $contactRepository;
    private $paymentMethodRepository;
    private $shopConfigRepository;

    public function __construct(PaymentRepository $paymentRepository,
        PaymentProviderManager $paymentProviderManager,
        ContactRepository $contactRepository,
        PaymentMethodRepository $paymentMethodRepository,
        ShopConfigRepository $shopConfigRepository
    ) {
        $this->paymentRepository       = $paymentRepository;
        $this->paymentProviderManager  = $paymentProviderManager;
        $this->contactRepository       = $contactRepository;
        $this->paymentMethodRepository = $paymentMethodRepository;
        $this->shopConfigRepository    = $shopConfigRepository;
    }


    /**
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\RedirectResponse|Response
     */
    public function indexAction(Request $request)
    {
        $form = $this->createForm(PaymentType::class);
        $form->handleRequest($request);
        $paymentMethod = $this->paymentMethodRepository->findByDefaultForPaymentOnline();
        $config        = $this->shopConfigRepository->findOne();
        if (!$paymentMethod) {
            throw new \Exception("Méthode de paiement inexistant pour le système de paiement en ligne");
        }
        if ($form->isSubmitted()) {
            if ($form->isValid()) {
                /** @var Payment $data */
                $payment = $form->getData();
                $this->paymentRepository->save($payment);
                $contact = $this->contactRepository->findOne();

                return $this->paymentProviderManager->createPaymentProviderManager($contact, $payment);
            } else {
                $this->addFlash('error', 'Le formulaire n\'est pas rempli correctement !');
            }
        }

        return $this->render(
            'payment.html.twig',
            [
                'classMenu'     => 'black',
                'form'          => $form->createView(),
                'paymentMethod' => $paymentMethod,
                'config'        => $config,
            ]
        );
    }

    /**
     * @param Request $request
     * @param Payment $payment
     * @return \Symfony\Component\HttpFoundation\RedirectResponse|Response
     */
    public function itemAction(Request $request, Payment $payment)
    {
        $form = $this->createForm(PaymentType::class, $payment);
        $form->handleRequest($request);
        $paymentMethod = $this->paymentMethodRepository->findByDefaultForPaymentOnline();
        $config        = $this->shopConfigRepository->findOne();

        return $this->render(
            'payment.html.twig',
            [
                'classMenu'     => 'black',
                'form'          => $form->createView(),
                'paymentMethod' => $paymentMethod,
                'config'        => $config,
            ]
        );
    }
}
