<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\ProductTaxType;
use CpCreation\VitiCore\Product\Model\ProductTax;
use CpCreation\VitiCore\Product\Repository\ProductTaxRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * @Security("is_granted('ROLE_ADMIN')")
 * Class ProductTaxController
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 * @Route("/product-tax")
 */
class ProductTaxController extends AbstractController
{
    private $productTaxRepository;

    public function __construct(ProductTaxRepository $productTaxRepository)
    {
        $this->productTaxRepository =  $productTaxRepository;
    }

    /**
     * @route("", name="admin_product_tax")
     * @Template("@CpCreationVitiCore/admin/product/tax/index.html.twig")
     */
    public function indexAction()
    {
        $tax = $this->productTaxRepository->findAll();

        return [
            "items" => $tax
        ];
    }


    /**
     * @param Request $request
     * @Route("/new", name="admin_product_tax_new")
     * @Template("@CpCreationVitiCore/admin/product/tax/new.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function newAction(Request $request)
    {

        $form = $this->createForm(ProductTaxType::class);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var ProductTax $data */
            $data = $form->getData();
            $this->productTaxRepository->save($data);
            $this->addFlash('alert-success', 'La taxe a été ajouté avec succès');

            return $this->redirectToRoute('admin_product_tax');

        }

        return [
            "form" => $form->createView(),
        ];
    }

    /**
     * @param ProductTax $tax
     * @param Request $request
     * @Route("/{id}/edit", name="admin_product_tax_edit")
     * @Template("@CpCreationVitiCore/admin/product/tax/edit.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function editAction(ProductTax $tax, Request $request)
    {
        $form = $this->createForm(ProductTaxType::class, $tax);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var ProductTax $data */
            $data = $form->getData();
            $this->productTaxRepository->save($data);
            $this->addFlash('alert-success', 'La taxe a été modifié avec succès');

            return $this->redirectToRoute('admin_product_tax');

        }

        return [
            "item" => $tax,
            "form" => $form->createView(),
        ];
    }

    /**
     * @param ProductTax $tax
     * @Route("/{id}/delete", name="admin_product_tax_delete")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteAction(ProductTax $tax)
    {
        $this->productTaxRepository->delete($tax);
        $this->addFlash('alert-success', 'La taxe a été supprimé avec succès.');

        return $this->redirectToRoute('admin_product_tax');
    }
}
