<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\LabelType;
use CpCreation\VitiCore\Contact\Model\Label;
use CpCreation\VitiCore\Contact\Repository\LabelRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * @Security("is_granted('ROLE_ADMIN')")
 * Class LabelController
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 * @Route("/label")
 */
class LabelController extends AbstractController
{
    private $labelRepository;

    public function __construct(LabelRepository $labelRepository)
    {
        $this->labelRepository = $labelRepository;
    }

    /**
     * @Route("", name="admin_label")
     * @Template("@CpCreationVitiCore/admin/label/index.html.twig")
     */
    public function indexAction()
    {
        $libraries = $this->labelRepository->findBy([], ['position' => 'ASC']);

        return [
            "items" => $libraries
        ];
    }

    /**
     * @param Request $request
     * @Route("/new", name="admin_label_new")
     * @Template("@CpCreationVitiCore/admin/label/new.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function newAction(Request $request)
    {
        $form = $this->createForm(LabelType::class);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var Label $data */
            $data = $form->getData();
            $this->labelRepository->save($data);
            $this->addFlash('alert-success', 'Le label a été ajouté avec succès');

            return $this->redirectToRoute('admin_label');
        }

        return [
            "form" => $form->createView(),
        ];
    }

    /**
     * @param Label $label
     * @param Request $request
     * @Route("/{id}/edit", name="admin_label_edit")
     * @Template("@CpCreationVitiCore/admin/label/edit.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function editAction(Label $label, Request $request){
        $form = $this->createForm(LabelType::class, $label);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var Label $data */
            $data = $form->getData();
            $this->labelRepository->save($data);
            $this->addFlash('alert-success', 'Le label a été modifié avec succès');

            return $this->redirectToRoute('admin_label');
        }

        return [
            "item" => $label,
            "form" => $form->createView(),
        ];
    }

    /**
     * @param Label $label
     * @Route("/{id}/delete", name="admin_label_delete")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteAction(Label $label)
    {
        $this->labelRepository->delete($label);
        $this->addFlash('alert-success', 'Le label a été supprimé avec succès.');

        return $this->redirectToRoute('admin_label');
    }

    /**
     * @param Label $label
     * @Route("/{id}/moveUp", name="admin_label_move_up")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function moveUpAction(Label $label)
    {
        $label->setPosition($label->getPosition() - 1);
        $this->labelRepository->save($label);
        $this->addFlash('alert-success', 'Le label a été remonté.');

        return $this->redirectToRoute('admin_label');
    }

    /**
     * @param Label $label
     * @Route("/{id}/moveDown", name="admin_label_move_down")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function moveDownAction(Label $label)
    {
        $label->setPosition($label->getPosition() + 1);
        $this->labelRepository->save($label);
        $this->addFlash('alert-success', 'Le label a été descendu.');

        return $this->redirectToRoute('admin_label');
    }
}
