<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Product\Model;


use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\HasTranslatable;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use CpCreation\VitiCore\Behavior\Impl\Translatable;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Sortable\Sortable;
use Ramsey\Uuid\Uuid;
use Gedmo\Mapping\Annotation as Gedmo;
use Ramsey\Uuid\UuidInterface;


/**
 * Class ProductCategory
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Product\Repository\ProductCategoryRepository")
 * @ORM\Table(name="product_category")
 * @ORM\HasLifecycleCallbacks()
 */
class ProductCategory implements HasTimestamp, Sortable, HasTranslatable
{
    use Timestamp, Translatable;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;

    /**
     * @ORM\Column(type="integer")
     * @Gedmo\SortablePosition()
     *
     * @var integer
     */
    private $position;

    /**
     * @ORM\Column(type="boolean", options={"default" : 1})
     *
     * @var boolean
     */
    private $pageCuvee;

    /**
     * @ORM\Column(type="boolean", options={"default" : 1})
     *
     * @var boolean
     */
    private $pageShop;

    /**
     * @ORM\OneToMany(targetEntity="Product", mappedBy="category", orphanRemoval=true)
     * @ORM\JoinColumn(name="product_category_id", referencedColumnName="id", nullable=true)
     * @ORM\OrderBy({"position" = "ASC"})
     * @var Collection<Product>
     */
    private $products;

    public function __construct()
    {
        $this->id        = Uuid::uuid4();
        $this->products  = new ArrayCollection();
        $this->pageCuvee = true;
        $this->pageShop  = true;
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }

    /**
     * @return int
     */
    public function getPosition(): int
    {
        return $this->position;
    }

    /**
     * @param int $position
     */
    public function setPosition(int $position)
    {
        $this->position = $position;
    }

    /**
     * @return bool
     */
    public function isPageCuvee(): bool
    {
        return $this->pageCuvee;
    }

    /**
     * @param bool $pageCuvee
     */
    public function setPageCuvee(bool $pageCuvee): void
    {
        $this->pageCuvee = $pageCuvee;
    }

    /**
     * @return bool
     */
    public function isPageShop(): bool
    {
        return $this->pageShop;
    }

    /**
     * @param bool $pageShop
     */
    public function setPageShop(bool $pageShop): void
    {
        $this->pageShop = $pageShop;
    }

    /**
     * @return Collection<Product>
     */
    public function getProducts(): Collection
    {
        return $this->products;
    }

}
