<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Media\Model;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;


/**
 * Class Image
 *
 * @ORM\Entity()
 * @ORM\HasLifecycleCallbacks()
 */
class Image extends Media
{
    /**
     * @var UploadedFile
     * 
     * @Assert\File(
     *     maxSize = "2M",
     *     mimeTypes = {"image/png", "image/jpeg","image/gif","image/jpg","image/svg+xml"},
     *     maxSizeMessage = "Le fichier est trop volumineux"
     * )
     */
    private $file;

    /**
     * @return UploadedFile
     */
    public function getFile(): ?UploadedFile
    {
        return $this->file;
    }

    /**
     * @param UploadedFile $file
     */
    public function setFile(UploadedFile $file): void
    {
        $this->file = $file;
    }
}