<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\History\Model;

use CpCreation\VitiCore\Behavior\HasImage;
use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\Impl\Image;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Validator\Context\ExecutionContextInterface;

/**
 * Class HistoryImage
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\History\Repository\HistoryImageRepository")
 * @ORM\Table(name="history_history_image")
 * @ORM\HasLifecycleCallbacks()
 */
class HistoryImage implements HasTimestamp, HasImage
{
    use Timestamp, Image;

    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="CpCreation\VitiCore\History\Model\History", inversedBy="images")
     * @ORM\JoinColumn(name="history_id", referencedColumnName="id", onDelete="cascade")
     * @Gedmo\SortableGroup()
     *
     * @var History
     */
    private $history;

    /**
     * @Gedmo\SortablePosition()
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var int
     */
    private $position;

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return History
     */
    public function getHistory(): ?History
    {
        return $this->history;
    }

    /**
     * @param History $history
     */
    public function setHistory(History $history): void
    {
        $this->history = $history;
    }

    /**
     * @return int
     */
    public function getPosition(): ?int
    {
        return $this->position;
    }

    /**
     * @param int $position
     */
    public function setPosition(int $position = null)
    {
        $this->position = $position;
    }

    /**
     * @param \Symfony\Component\Validator\Context\ExecutionContextInterface $context
     * @Assert\Callback()
     */
    public function validate(ExecutionContextInterface $context)
    {
        if (!$this->getImage()) {
            $message = 'Veuillez ajouter une image';
            $context->buildViolation($message)
                    ->atPath("image.file")
                    ->addViolation();
        }
    }
}