<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Depot\Model;

use CpCreation\VitiCore\Behavior\HasTranslatable;
use CpCreation\VitiCore\Behavior\Impl\Translatable;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;

/**
 * Class Category
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Depot\Repository\CategoryRepository")
 * @ORM\Table(name="depot_category")
 * @ORM\HasLifecycleCallbacks()
 */
class Category implements HasTranslatable
{
    use Translatable;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;

    /**
     * @Gedmo\SortablePosition()
     * @ORM\Column(type="integer", nullable=true)
     *
     * @var int
     */
    private $position;

    /**
     * @ORM\OneToMany(targetEntity="Depot", mappedBy="category")
     * @ORM\OrderBy({"position"="ASC"})
     *
     * @var Collection<Depot>
     */
    private $depots;

    public function __construct()
    {
        $this->id = Uuid::uuid4();
        $this->depots = new ArrayCollection();
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }

    /**
     * @return int
     */
    public function getPosition(): ?int
    {
        return $this->position;
    }

    /**
     * @param int $position
     */
    public function setPosition(int $position)
    {
        $this->position = $position;
    }

    /**
     * @return Collection
     */
    public function getDepots(): Collection
    {
        return $this->depots;
    }

}