<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Service;

use nusoap_client;


class MondialRelayService
{
    const URL              = "https://api.mondialrelay.com/Web_Services.asmx?WSDL";
    const COMPANY_TEST     = "BDTEST13";
    const PRIVATE_KEY_TEST = "OrivateK";


    public function getRelayFromAddress()
    {
        $client                   = new nusoap_client(self::URL, true);
        $client->soap_defencoding = "utf-8";

        $params = [
            'Enseigne'        => self::COMPANY_TEST,
            'Pays'            => "FR",
            'Ville'           => "",
            'CP'              => "51200",
            'Latitude'        => "",
            'Longitude'       => "",
            'Taille'          => "",
            'Poids'           => "",
            'Action'          => "",
            'DelaiEnvoi'      => "0",
            'RayonRecherche'  => "20",
            'NombreResultats' => "20",
        ];

        $code               = implode("", $params);
        $code               .= self::PRIVATE_KEY_TEST;
        $params['Security'] = strtoupper(md5($code));

        $result = $client->call(
            'WSI4_PointRelais_Recherche',
            $params,
            'http://api.mondialrelay.com/',
            'http://api.mondialrelay.com/WSI4_PointRelais_Recherche'
        );

        if ($client->fault) {
            echo '<h2>Fault (Expect - The request contains an invalid SOAP body)</h2><pre>';
            print_r($result);
            echo '</pre>';
        } else {
            $err = $client->getError();
            if ($err) {
                echo '<h2>Error</h2><pre>'.$err.'</pre>';
            } else {
                echo '<h2>Result</h2><pre>';
                print_r($result);
                echo '</pre>';
            }
        }
        echo '<h2>Request</h2><pre>'.htmlspecialchars($client->request, ENT_QUOTES).'</pre>';
        echo '<h2>Response</h2><pre>'.htmlspecialchars($client->response, ENT_QUOTES).'</pre>';
        echo '<h2>Debug</h2><pre>'.htmlspecialchars($client->getDebug(), ENT_QUOTES).'</pre>';
        //return htmlspecialchars($client->request, ENT_QUOTES) . "/" . htmlspecialchars($client->response, ENT_QUOTES) . "/" . htmlspecialchars($client->getDebug());
    }
}