<?php
/**
 * @author Colinet Julien
 */
namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Routing;

use Symfony\Component\Config\Loader\Loader;
use Symfony\Component\HttpKernel\KernelInterface;
use Symfony\Component\Routing\RouteCollection;

class VitiCoreLoader extends Loader
{
    /**
     * @var string
     */
    private $environment;
    public function __construct(KernelInterface $kernel)
    {
        $this->environment = $kernel->getEnvironment();
    }

    public function load($resource, $type = null)
    {

        $routes = new RouteCollection();

        $resource = '@CpCreationVitiCoreBundle/Resources/config/routing.yaml';
        $type = 'yaml';
        $importedRoutes = $this->import($resource, $type);

        $routes->addCollection($importedRoutes);

        if ($this->environment === "dev")
        {
            $resource = '@CpCreationVitiCoreBundle/Resources/config/routes/dev/twig.yaml';
            $type = 'yaml';
            $importedRoutes = $this->import($resource, $type);
            $routes->addCollection($importedRoutes);

            $resource = '@CpCreationVitiCoreBundle/Resources/config/routes/dev/web_profiler.yaml';
            $type = 'yaml';
            $importedRoutes = $this->import($resource, $type);
            $routes->addCollection($importedRoutes);
        }

        $resource = '@CpCreationVitiCoreBundle/Resources/config/routes/api_platform.yaml';
        $type = 'yaml';
        $importedRoutes = $this->import($resource, $type);
        $routes->addCollection($importedRoutes);

        $resource = '@CpCreationVitiCoreBundle/Resources/config/routes/fos_js_routing.yaml';
        $type = 'yaml';
        $importedRoutes = $this->import($resource, $type);
        $routes->addCollection($importedRoutes);

        $resource = '@CpCreationVitiCoreBundle/Resources/config/routes/imagine.yaml';
        $type = 'yaml';
        $importedRoutes = $this->import($resource, $type);
        $routes->addCollection($importedRoutes);

        $resource = '@CpCreationVitiCoreBundle/Resources/config/routes/js_translation.yaml';
        $type = 'yaml';
        $importedRoutes = $this->import($resource, $type);
        $routes->addCollection($importedRoutes);

        return $routes;
    }

    public function supports($resource, $type = null)
    {
        return 'viti-core' === $type;
    }
}
