<?php

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslationsType;
use CpCreation\VitiCore\Gite\Model\Gite;
use CpCreation\VitiCore\Gite\Model\GiteImage;
use CpCreation\VitiCore\Gite\Model\Room;
use CpCreation\VitiCore\Gite\Model\RoomImage;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * @author Colinet Julien
 */
class RoomType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'translations', TranslationsType::class, [
                    'label'           => false,
                    'fields'          => [
                        'header'       => [
                            'field_type' => TextType::class,
                            'label'      => 'Header',
                            'required'   => true,
                        ],
                        'title'    => [
                            'field_type' => TextType::class,
                            'label'      => 'Titre',
                            'required'   => false,
                        ],
                        'description' => [
                            'field_type' => TrumbowygType::class,
                            'label'      => 'Description',
                            'required'   => true,
                        ],
                    ],
                    'excluded_fields' => ['slug'],
                ]
            )
            ->add(
                'images', ImageCollectionType::class, [
                    'label'          => false,
                    'entry_type'     => RoomImageType::class,
                    'allow_add'      => true,
                    'allow_delete'   => true,
                    'error_bubbling' => false,
                    'prototype'      => true,
                    'by_reference'   => false,
                    'delete_empty'   => true,
                    'attr'           => [
                        'data-name-prefix' => 'ImageRoom',
                        'class'            => "image-collection",
                    ],
                    'entry_options'  => [
                        'data_class' => RoomImage::class,
                        'label'      => false,
                    ],
                ]
            )
            ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => Room::class,
            ]
        );
    }
}
