<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use CpCreation\VitiCore\Product\Model\ProductTax;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\PercentType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ProductTaxType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'name', TextType::class,
                [
                    'label' => 'Nom de la Taxe'
                ]
            )
            ->add(
                'byDefault', CheckboxType::class,
                [
                   'label' => 'Taxe par défaut',
                   'required'   => false
                ]
            )
            ->add(
                'inPro', CheckboxType::class,
                [
                    'label' => 'Appliquer Taxe pour les pro dans le pays de vente',
                    'required'   => false
                ]
            )
            ->add(
                'outPro', CheckboxType::class,
                [
                    'label' => 'Appliquer Taxe pour les pro hors du pays de vente',
                    'required'   => false
                ]
            )
            ->add(
                'inCustomer', CheckboxType::class,
                [
                    'label' => 'Appliquer Taxe pour les particuliers dans le pays de vente',
                    'required'   => false
                ]
            )
            ->add(
                'outCustomer', CheckboxType::class,
                [
                    'label' => 'Appliquer Taxe pour les particuliers hors du pays de vente',
                    'required'   => false
                ]
            )
            ->add('value', PercentType::class, ['label' => 'Valeur de la Tva', 'required' => true]

            );
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => ProductTax::class,
            ]
        );
    }
}
