<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\Payment;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\DataTransformerInterface;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;
use Symfony\Component\Serializer\Serializer;
use CpCreation\VitiCore\Cart\Model\Payment\Axepta;
use function Sodium\add;

class AxeptaPaymentType extends AbstractType implements PaymentMethodInterface, DataTransformerInterface
{
    const TYPE = 'axepta';

    private $serializer;

    public function __construct()
    {
        $normalizers = [new ObjectNormalizer()];
        $this->serializer = new Serializer($normalizers);
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name',TextType::class,[
                'label' => "Nom de la méthode de paiement",
                'required' => true
            ])
            ->add('merchant_id', TextType::class,[
                'label' => 'ID du commerçant',
                'required' => true
            ])
            ->add('blowfish', TextType::class,[
                'label' => 'Blowfish',
                'required' => true
            ])
            ->add('hmackey', TextType::class, [
                'label' => 'Clé HMAC',
                'required' => true
            ])
        ;

        $builder->addModelTransformer($this);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Axepta::class
        ]);
    }

    public function transform($data)
    {

        return $this->serializer->denormalize($data, Axepta::class);
    }

    public function reverseTransform($data)
    {

        return $this->serializer->normalize($data);
    }

    public function getMethod()
    {
        return static::TYPE;
    }

    public function getBlockPrefix()
    {
        return 'monetico_payment';
    }
}
