<?php

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslationsType;
use CpCreation\VitiCore\Newsletter\Model\Newsletter;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * @author Colinet Julien
 */
class NewsletterType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'file', FileType::class, ['label' => 'Fiche', 'required' => true]
            )
            ->add(
                'translations', TranslationsType::class, [
                    'label'           => false,
                    'fields'          => [
                        'title' => [
                            'field_type' => TextType::class,
                            'label'      => 'Titre',
                            'required'   => true,
                        ],

                    ],
                    'excluded_fields' => ['slug'],
                ]
            );
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => Newsletter::class,
            ]
        );
    }
}
