<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslatedEntityType;
use A2lix\TranslationFormBundle\Form\Type\TranslationsType;
use CpCreation\VitiCore\Depot\Model\Category;
use CpCreation\VitiCore\Depot\Model\Depot;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CountryType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class DepotType extends AbstractType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'category', TranslatedEntityType::class, [
                    'label'                => 'Catégorie',
                    'class'                => Category::class,
                    'translation_property' => 'name',
                    'required'             => false,
                    'multiple'             => false
                ]
            )
            ->add(
                'translations', TranslationsType::class, [
                    'label'  => false,
                    'fields' => [
                        'name'       => [
                            'field_type' => TextType::class,
                            'label'      => 'Nom',
                            'required'   => false,
                        ],
                        'description' => [
                            'field_type' => TrumbowygType::class,
                            'label'      => 'Description',
                            'required'   => false,
                        ],
                    ],
                ]
            )
            ->add('address', TextType::class, ['label' => 'Adresse', 'required' => false])
            ->add('postal', TextType::class, ['label' => 'Code postal', 'required' => true])
            ->add('city', TextType::class, ['label' => 'Ville', 'required' => true])
            ->add(
                'country', CountryType::class, [
                    'label'    => 'Pays',
                    'required' => true,
                ]
            )
            ->add('phone', TextType::class, ['label' => 'Téléphone', 'required' => false])
            ->add('email', TextType::class, ['label' => 'Email', 'required' => false])
            ->add('website', TextType::class, ['label' => 'Site', 'required' => false])

        ;

    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                "data_class" => Depot::class,
            ]
        );
    }
}