<?php

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use CpCreation\VitiCore\Contact\Model\Contact;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\UrlType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * @author Colinet Julien
 */
class ContactType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('company', TextType::class, ['label' => 'Nom de l\'entreprise', 'required' => true])
            ->add('firstname', TextType::class, ['label' => 'Nom du contact', 'required' => false])
            ->add('lastname', TextType::class, ['label' => 'Prénom du contact', 'required' => false])
            ->add('address', TextType::class, ['label' => 'Rue', 'required' => true])
            ->add('postal', TextType::class, ['label' => 'Code postal', 'required' => true])
            ->add('city', TextType::class, ['label' => 'Ville', 'required' => true])
            ->add('phone1', TextType::class, ['label' => 'Téléphone 1', 'required' => true])
            ->add('phone2', TextType::class, ['label' => 'Téléphone 2', 'required' => false])
            ->add('phone3', TextType::class, ['label' => 'Téléphone 2', 'required' => false])
            ->add('emailFrom', EmailType::class, ['label' => 'Email d\'envoie', 'required' => true])
            ->add('emailToMessage', EmailType::class, ['label' => 'Email réception message contact', 'required' => true])
            ->add('emailToShop', EmailType::class, ['label' => 'Email réception commande', 'required' => true])
            ->add('facebook', UrlType::class, ['label' => 'Facebook', 'required' => false])
            ->add('twitter', UrlType::class, ['label' => 'Twitter', 'required' => false])
            ->add('instagram', UrlType::class, ['label' => 'Instagram', 'required' => false])
            ->add('recaptcha', ChoiceType::class, [
                'label'       => false,
                'expanded'    => true,
                'multiple'    => false,
                'choices'     => [
                    "Oui" => true,
                    "Non" => false,
                ],
                'placeholder' => null,
                'required'    => false,
            ])
            ->add('recaptchaKeyPrivate', TextType::class, ['label' => 'ReCaptcha Clef Privée', 'required' => false])
            ->add('recaptchaKeyPublic', TextType::class, ['label' => 'ReCaptcha Clef Public', 'required' => false])
            ->add('instagram', UrlType::class, ['label' => 'Instagram', 'required' => false])
            ->add(
                'file', FileType::class, ['label' => 'CGV', 'required' => false, 'title' => false]
            )
            ->add(
                'image', ImageType::class, ['label' => 'Logo pour email']
            )
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => Contact::class,
            ]
        );
    }
}
