<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Site;

use CpCreation\VitiCore\Product\Model\Product;
use CpCreation\VitiCore\Product\Repository\ProductRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;

class CuveeController extends AbstractController
{
    private $productRepository;

    public function __construct(ProductRepository $productRepository)
    {
        $this->productRepository = $productRepository;
    }

    /**
     * @param Request $request
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction(Request $request)
    {
        $cuvees    = $this->productRepository->findOnlyCuvee();
        $names     = [];
        $refCuvees = [];

        /** @var Product $cuvee */
        foreach ($cuvees as $key => $cuvee) {
            if (in_array($cuvee->getName(), $names)) {
                $prevCuvee = $refCuvees[$cuvee->getName()];
                $cuvee->translate($request->getLocale())->setQuality($prevCuvee['quality'].' & '.$cuvee->getQuality());
                unset($cuvees[$prevCuvee['key']]);
            } else {
                array_push($names, $cuvee->getName());
                $refCuvees[$cuvee->getName()] =
                    [
                        'key'     => $key,
                        'quality' => $cuvee->getQuality(),
                    ];
            }
        }

        return $this->render(
            'cuvees.html.twig',
            [
                'classMenu' => 'black',
                'subMenu'   => true,
                'cuvees'    => $cuvees,
            ]
        );
    }
}
