<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Site;

use CpCreation\VitiCore\Gite\Model\Gite;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;

class CottageController extends AbstractController
{
    /**
     * @param Gite $gite
     *
     * @ParamConverter("gite", converter="translation_converter")
     * @return \Symfony\Component\HttpFoundation\RedirectResponse|\Symfony\Component\HttpFoundation\Response
     */
    public function indexAction(Gite $gite)
    {
        return $this->render(
            'cottage.html.twig',
            [
                'classMenu' => 'black',
                'cottage'   => $gite,
            ]
        );
    }
}
