<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\ContactType;
use CpCreation\VitiCore\Contact\Model\Contact;
use CpCreation\VitiCore\Contact\Repository\ContactRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class ContactController
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 *
 * @Security("is_granted('ROLE_ADMIN')")
 * @Route("/contact")
 */
class ContactController extends AbstractController
{

    private $contactRepository;

    public function __construct(ContactRepository $contactRepository)
    {
        $this->contactRepository = $contactRepository;
    }

    /**
     * @route("", name="admin_contact")
     * @Template("@CpCreationVitiCore/admin/contact/index.html.twig")
     */
    public function indexAction()
    {
        $awards = $this->contactRepository->findBy([], ['createdAt' => 'DESC']);

        return [
            "items" => $awards,
        ];
    }

    /**
     * @param Request $request
     * @Route("/new", name="admin_contact_new")
     * @Template("@CpCreationVitiCore/admin/contact/new.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function newAction(Request $request)
    {
        $form = $this->createForm(ContactType::class);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            /** @var Contact $data */
            $data = $form->getData();
            $this->contactRepository->save($data);
            $this->addFlash('alert-success', 'Le contact '.$data->getCompany().' a été ajouté avec succès');

            return $this->redirectToRoute('admin_contact');
        }

        return [
            "form" => $form->createView(),
        ];
    }

    /**
     * @param Contact   $contact
     * @param Request $request
     * @Route("/{id}/edit", name="admin_contact_edit")
     * @Template("@CpCreationVitiCore/admin/contact/edit.html.twig")
     *
     * @return array|\Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function editAction(Contact $contact, Request $request)
    {
        $form = $this->createForm(ContactType::class, $contact);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            /** @var Contact $data */
            $data = $form->getData();
            $data->setUpdatedAt(new \DateTime()); // Forcer Update de doctrine
            $this->contactRepository->save($data);
            $this->addFlash('alert-success', 'Le contact '.$data->getCompany().' a été modifié avec succès');

            return $this->redirectToRoute('admin_contact');

        }

        return [
            "item" => $contact,
            "form" => $form->createView(),
        ];
    }

    /**
     * @param Contact $contact
     * @Route("/{id}/delete", name="admin_contact_delete")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteAction(Contact $contact)
    {
        $this->contactRepository->delete($contact);
        $this->addFlash('alert-success', 'Le contact '.$contact->getCompany().' a été supprimé avec succès.');

        return $this->redirectToRoute('admin_contact');
    }
}
