<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Doctrine\EventSubscriber;

use CpCreation\VitiCore\Behavior\HasGeocoder;
use Doctrine\Common\EventSubscriber;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Events;
use Geocoder\Query\GeocodeQuery;

class GeocoderSubscriber implements EventSubscriber
{
    private $apiKey;

    public function __construct($apiKeyServerGooglemap)
    {
        $this->apiKey = $apiKeyServerGooglemap;
    }

    public function getSubscribedEvents()
    {

        return [
            Events::prePersist,
            Events::preUpdate,
        ];
    }

    /**
     * @param LifecycleEventArgs $args
     */
    public function prePersist(LifecycleEventArgs $args)
    {
        $entity = $args->getEntity();
        if ($entity instanceof HasGeocoder) {
            $coordinates = $this->geocoder($entity);
            if ($coordinates)
            {
                $entity->setLat($coordinates->getLatitude());
                $entity->setLng($coordinates->getLongitude());
            }

        }
    }

    /**
     * @param LifecycleEventArgs $args
     */
    public function preUpdate(LifecycleEventArgs $args)
    {
        $entity = $args->getEntity();
        if ($entity instanceof HasGeocoder) {
            $coordinates = $this->geocoder($entity);
            if ($coordinates)
            {
                $entity->setLat($coordinates->getLatitude());
                $entity->setLng($coordinates->getLongitude());
            }
        }
    }

    private function geocoder(HasGeocoder $geocodable)
    {
        $httpClient = new \Http\Adapter\Guzzle6\Client();
        $provider   = new \Geocoder\Provider\GoogleMaps\GoogleMaps($httpClient, null, $this->apiKey);
        $geocoder   = new \Geocoder\StatefulGeocoder($provider, 'en');
        $result     = $geocoder->geocodeQuery(GeocodeQuery::create($geocodable->getAddress().' '.$geocodable->getPostal().' '.$geocodable->getCity().' '.$geocodable->getCountry()));
        if ($result->isEmpty()) {

            return null;
        }

        return $result->first()->getCoordinates();
    }
}
