<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Behavior;

use CpCreation\VitiCore\Cart\Model\PaymentMethod;

interface HasPayment
{
    /**
     * @return PaymentMethod
     */
    public function getPaymentMethod(): ?PaymentMethod;

    /**
     * @return int
     */
    public function getTotal(): ?int;

    /**
     * @return string
     */
    public function getToken(): ?string;

    /**
     * @return string
     */
    public function getEmail(): ?string;

    /**
     * @return string
     */
    public function getFirstname(): ?string;

    /**
     * @return string
     */
    public function getLastname(): ?string;

    /**
     * @return string
     */
    public function getPhone(): ?string;

    /**
     * @return string
     */
    public function getCompany(): ?string;

    /**
     * @return string
     */
    public function getStreet(): ?string;

    /**
     * @return string
     */
    public function getPostalCode(): ?string;

    /**
     * @return string
     */
    public function getCity(): ?string;

    /**
     * @return string
     */
    public function getCountry(): ?string;
}
