<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Model\Translation;

use CpCreation\VitiCore\Behavior\Impl\Translation;
use Doctrine\ORM\Mapping as ORM;
use Knp\DoctrineBehaviors\Contract\Entity\TranslationInterface;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;

/**
 * Class ShippingConfigTranslation
 *
 * @ORM\Entity()
 * @ORM\Table(name="shop_shipping_config_translation")
 * @ORM\HasLifecycleCallbacks()
 */
class ShippingConfigTranslation implements TranslationInterface
{
    use Translation;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;
    
    /**
     * @ORM\Column(type="string", nullable=true)
     *
     * @var string
     */
    private $shippingText;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string
     */
    private $shippingInfo;

    public function __construct()
    {
        $this->id       = Uuid::uuid4();
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }
    
    /**
     * @return string
     */
    public function getShippingText(): ?string
    {
        return $this->shippingText;
    }

    /**
     * @param string $shippingText
     */
    public function setShippingText(string $shippingText = null): void
    {
        $this->shippingText = $shippingText;
    }

    /**
     * @return string
     */
    public function getShippingInfo(): ?string
    {
        return $this->shippingInfo;
    }

    /**
     * @param string $shippingInfo
     */
    public function setShippingInfo(string $shippingInfo = null)
    {
        $this->shippingInfo = $shippingInfo;
    }
}
