<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Product\Model;

use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;

/**
 * Class ProductTax
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\Product\Repository\ProductTaxRepository")
 * @ORM\Table(name="product_tax")
 * @ORM\HasLifecycleCallbacks()
 */
class ProductTax implements HasTimestamp
{
    use Timestamp;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;

    /**
     * @ORM\Column(type="text")
     *
     * @var string
     */
    private $name;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $byDefault;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $inPro;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $outPro;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $inCustomer;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var boolean
     */
    private $outCustomer;

    /**
     * @ORM\Column(type="decimal", precision=3, scale=2)
     *
     * @var float
     */
    private $value;

    public function __construct()
    {
        $this->id    = Uuid::uuid4();
        $this->byDefault  = false;
        $this->inPro = true;
        $this->outPro = false;
        $this->inCustomer = true;
        $this->outCustomer = true;
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name = null): void
    {
        $this->name = $name;
    }


    /**
     * @return bool
     */
    public function isByDefault(): bool
    {
        return $this->byDefault;
    }

    /**
     * @param bool $byDefault
     */
    public function setByDefault(bool $byDefault): void
    {
        $this->byDefault = $byDefault;
    }

    /**
     * @return bool
     */
    public function isInPro(): bool
    {
        return $this->inPro;
    }

    /**
     * @param bool $inPro
     */
    public function setInPro(bool $inPro): void
    {
        $this->inPro = $inPro;
    }

    /**
     * @return bool
     */
    public function isOutPro(): bool
    {
        return $this->outPro;
    }

    /**
     * @param bool $outPro
     */
    public function setOutPro(bool $outPro): void
    {
        $this->outPro = $outPro;
    }

    /**
     * @return bool
     */
    public function isInCustomer(): bool
    {
        return $this->inCustomer;
    }

    /**
     * @param bool $inCustomer
     */
    public function setInCustomer(bool $inCustomer): void
    {
        $this->inCustomer = $inCustomer;
    }

    /**
     * @return bool
     */
    public function isOutCustomer(): bool
    {
        return $this->outCustomer;
    }

    /**
     * @param bool $outCustomer
     */
    public function setOutCustomer(bool $outCustomer): void
    {
        $this->outCustomer = $outCustomer;
    }

    /**
     * @return float
     */
    public function getValue(): ?float
    {
        return $this->value;
    }

    /**
     * @param float $value
     */
    public function setValue(float $value = null): void
    {
        $this->value = $value;
    }
}