<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Newsletter\Repository;

use CpCreation\VitiCore\Newsletter\Model\Newsletter;
use CpCreation\VitiCore\Repository\BaseRepository;
use Doctrine\Persistence\ManagerRegistry;

class NewsletterRepository extends BaseRepository
{
    /**
     * NewsletterRepository constructor.
     * @param ManagerRegistry $registry
     * @throws \ReflectionException
     */
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Newsletter::class);
    }

    /**
     * @return mixed
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function findLastNewsletter()
    {
        $qb = $this->createQueryBuilder('n')
                   ->orderBy('n.createdAt', 'DESC')
                   ->getQuery()
                   ->setMaxResults(1)
                   ->getOneOrNullResult();

        return $qb;
    }
}