<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Cart\Model\Payment;

use Symfony\Component\Validator\Constraints as Assert;

class Axepta
{
    /**
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $name;

    /**
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $merchant_id;

    /**
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $hmacKey;

    /**
     * @Assert\NotBlank
     * Clé de chiffrement Blowfish
     *
     * @var string
     */
    private $blowfish;

    public function __construct()
    {}

    /**
     * @return string
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getHmacKey(): ?string
    {
        return $this->hmacKey;
    }

    /**
     * @param string $hmacKey
     */
    public function setHmacKey(string $hmacKey)
    {
        $this->hmacKey = $hmacKey;
    }

    /**
     * @return string
     */
    public function getMerchantId(): string
    {
        return $this->merchant_id;
    }

    /**
     * @param string $merchant_id
     */
    public function setMerchantId(string $merchant_id): void
    {
        $this->merchant_id = $merchant_id;
    }

    /**
     * @return string
     */
    public function getBlowfish(): string
    {
        return $this->blowfish;
    }

    /**
     * @param string $blowfish
     */
    public function setBlowfish(string $blowfish): void
    {
        $this->blowfish = $blowfish;
    }

}
