<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Twig;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Filesystem\FileFilesystem;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Filesystem\ImageFilesystem;
use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;

class FileExtension extends AbstractExtension
{

    private $imageFilesystem;
    private $fileFilesystem;
    private $kernelRootDir;

    public function __construct(ImageFilesystem $imageFilesystem, FileFilesystem $fileFilesystem, $kernelRootDir)
    {
        $this->imageFilesystem = $imageFilesystem;
        $this->fileFilesystem  = $fileFilesystem;
        $this->kernelRootDir   = $kernelRootDir;
    }

    public function getFilters()
    {
        return [
            new TwigFilter('file_path', [$this, 'filePathFilter']),
            new TwigFilter('image_path', [$this, 'imagePathFilter']),
        ];
    }

    public function filePathFilter($path)
    {

        return str_replace($this->kernelRootDir.'/../public', '', $this->fileFilesystem->getAdapter()->getPathPrefix().$path);
    }

    public function imagePathFilter($path)
    {

        return str_replace($this->kernelRootDir.'/../public', '', $this->imageFilesystem->getAdapter()->getPathPrefix().$path);
    }

    public function filePathAbsoluteFilter($path)
    {

        return $this->fileFilesystem->getAdapter()->getPathPrefix().$path;
    }

    public function imagePathAbsoluteFilter($path)
    {

        return $this->imageFilesystem->getAdapter()->getPathPrefix().$path;
    }
}