<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Site;


use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;

class RecaptchaType extends AbstractType
{
    private $reCaptchaKeyPublic;

    public function __construct(string $reCaptchaKeyPublic)
    {
        $this->reCaptchaKeyPublic = $reCaptchaKeyPublic;
    }

    public function buildView(FormView $view, FormInterface $form, array $options)
    {
        parent::buildView($view, $form, $options);
        $attr                 = $view->vars['attr'];
        $attr['class']        = 'g_recaptcha';
        $attr['data-sitekey'] = $this->reCaptchaKeyPublic;
        $view->vars['attr']   = $attr;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'mapped' => false,
            ]
        );
    }

    public function getParent()
    {
        return HiddenType::class;
    }


}
