<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use A2lix\TranslationFormBundle\Form\Type\TranslationsType;
use CpCreation\VitiCore\Gite\Model\RoomImage;
use CpCreation\VitiCore\Shop\Model\ShopConfig;
use CpCreation\VitiCore\Shop\Model\ShopConfigMultiple;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\CountryType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ShopConfigType extends AbstractType
{

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('viewCategory', CheckboxType::class, ['label' => 'Afficher les catégories produits' , 'required' => false])
            ->add('viewOrderByCategory', CheckboxType::class, ['label' => 'Afficher les cuvées rangées par catégorie avec le titre de la catégorie ' , 'required' => false])
            ->add('hidePriceDefault', CheckboxType::class, ['label' => 'Afficher la boutique sans prix' , 'required' => false])
            ->add('disableLogoBank', CheckboxType::class, ['label' => 'Ne plus afficher le logo de la banque' , 'required' => false])
            ->add('viewFavoriteCat', CheckboxType::class, ['label' => 'Afficher la catégorie Favoris dans la vue avec Swipe des catégories de la boutique' , 'required' => false])
            ->add('enabledCityField', CheckboxType::class, ['label' => 'Activer le champ Ville dans la boutique' , 'required' => false])
            ->add('enableAwardShop', CheckboxType::class, ['label' => 'Afficher les médailles sur les produits dans la boutique' , 'required' => false])
            ->add('enableCountriesForShop', CountryType::class, [
                'label'        => 'Activer seulement la boutique pour les pays ci-dessous',
                'multiple'     => true,
                'attr'         => [
                    'class' => 'select2',
                ],
                'required'     => false,
            ])
            ->add('disableCountriesForShop', CountryType::class, [
                'label'        => 'Désactiver seulement la boutique pour les pays ci-dessous',
                'multiple'     => true,
                'attr'         => [
                    'class' => 'select2',
                ],
                'required'     => false,
            ])
            ->add('maxAwardsVisibleInShop', TextType::class, ['label' => 'Nombre de médaille maximum à afficher sur la boutique' , 'required' => false])
            ->add(
                'translations', TranslationsType::class, [
                    'label'  => false,
                    'required_locales' => [],
                    'fields' => [
                        'favoriteCatName' => [
                            'field_type' => TextType::class,
                            'label'      => 'Nom de la catégorie "Favoris" ',
                            'required'   => false,
                        ],
                    ],
                ]
            )
            ->add(
                'multiples', CollectionType::class, [
                    'label'          => false,
                    'entry_type'     => ShopConfigMultipleType::class,
                    'allow_add'      => true,
                    'allow_delete'   => true,
                    'error_bubbling' => false,
                    'prototype'      => true,
                    'by_reference'   => false,
                    'delete_empty'   => true,
                    'attr'           => [
                        'data-name-prefix' => 'Collection',
                        'class'            => "multiple-collection",
                    ],
                    'entry_options'  => [
                        'data_class' => ShopConfigMultiple::class,
                        'label'      => false,
                    ],
                ]
            )
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => ShopConfig::class
            ]
        );
    }
}
