<?php

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use CpCreation\VitiCore\Contact\Model\Contact;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\UrlType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * @author Colinet Julien
 */
class ContactType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('company', TextType::class, ['label' => 'Nom de l\'entreprise', 'required' => true,'attr' => [ "autocomplete" =>"new-field"]])
            ->add('firstname', TextType::class, ['label' => 'Nom du contact', 'required' => false,'attr' => [ "autocomplete" =>"new-field"]])
            ->add('lastname', TextType::class, ['label' => 'Prénom du contact', 'required' => false,'attr' => [ "autocomplete" =>"new-field"]])
            ->add('address', TextType::class, ['label' => 'Rue', 'required' => true,'attr' => [ "autocomplete" =>"new-field"]])
            ->add('postal', TextType::class, ['label' => 'Code postal', 'required' => true,'attr' => [ "autocomplete" =>"new-field"]])
            ->add('city', TextType::class, ['label' => 'Ville', 'required' => true,'attr' => [ "autocomplete" =>"new-field"]])
            ->add('phone1', TextType::class, ['label' => 'Téléphone 1', 'required' => true,'attr' => [ "autocomplete" =>"new-field"]])
            ->add('phone2', TextType::class, ['label' => 'Téléphone 2', 'required' => false,'attr' => [ "autocomplete" =>"new-field"]])
            ->add('phone3', TextType::class, ['label' => 'Téléphone 2', 'required' => false,'attr' => [ "autocomplete" =>"new-field"]])
            ->add('emailFrom', EmailType::class, ['label' => 'Email d\'envoie', 'required' => true,'attr' => [ "autocomplete" =>"new-field"]])
            ->add('emailToMessage', EmailType::class, ['label' => 'Email réception message contact', 'required' => true,'attr' => [ "autocomplete" =>"new-field"]])
            ->add('emailToShop', EmailType::class, ['label' => 'Email réception commande', 'required' => true,'attr' => [ "autocomplete" =>"new-field"]])
            ->add('facebook', UrlType::class, ['label' => 'Facebook', 'required' => false,'attr' => [ "autocomplete" =>"new-field"]])
            ->add('twitter', UrlType::class, ['label' => 'Twitter', 'required' => false,'attr' => [ "autocomplete" =>"new-field"]])
            ->add('instagram', UrlType::class, ['label' => 'Instagram', 'required' => false,'attr' => [ "autocomplete" =>"new-field"]])
            ->add('recaptcha', ChoiceType::class, [
                'label'       => false,
                'expanded'    => true,
                'multiple'    => false,
                'choices'     => [
                    "Oui" => true,
                    "Non" => false,
                ],
                'placeholder' => null,
                'required'    => false,
            ])
            ->add('recaptchaKeyPrivate', TextType::class, ['label' => 'ReCaptcha Clef Privée', 'required' => false])
            ->add('recaptchaKeyPublic', TextType::class, ['label' => 'ReCaptcha Clef Public', 'required' => false])
            ->add('instagram', UrlType::class, ['label' => 'Instagram', 'required' => false])
            ->add(
                'cgv', TrumbowygType::class, ['label' => 'CGV', 'required' => false]
            )
            ->add(
                'committeeChampagneSiret', TextType::class, ['label' => 'Ressortissant du Comité Champagne (SIRET)', 'required' => false]
            )
            ->add(
                'committeeChampagneIdentifiant', TextType::class, ['label' => 'Identifiant unique fournit par l\'ADEME (FRXXX)', 'required' => false]
            )
            ->add(
                'image', ImageType::class, ['label' => 'Logo pour email']
            )
            ->add('editorCompany', TextType::class, ['label' => 'Dénomination de la société', 'required' => true,'attr' => [ "autocomplete" =>"new-field"]])
            ->add('editorAddress', TextType::class, ['label' => 'Adresse', 'required' => true,'attr' => [ "autocomplete" =>"new-field"]])
            ->add('editorPostal', TextType::class, ['label' => 'Code postal', 'required' => true, 'attr' => [ "autocomplete" =>"new-field"]])
            ->add('editorCity', TextType::class, ['label' => 'Ville', 'required' => true,'attr' => [ "autocomplete" =>"new-field"]])
            ->add('editorRcs', TextType::class, ['label' => 'RCS', 'required' => true,'attr' => [ "autocomplete" =>"new-field"]])
            ->add('editorTva', TextType::class, ['label' => 'TVA intra.', 'required' => true,'attr' => [ "autocomplete" =>"new-field"]])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => Contact::class,
            ]
        );
    }
}
