<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\EventListener;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Session\Flash\FlashBagInterface;
use Symfony\Component\HttpKernel\Event\RequestEvent;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Contracts\Translation\TranslatorInterface;

class RecaptchaFormSubscriber implements EventSubscriberInterface
{
    /** @var string */
    private $reCaptchaKeyPrivate;

    /**
     * @var FlashBagInterface
     */
    private $flashBag;

    /**
     * @var TranslatorInterface
     */
    private $translator;

    public function __construct($reCaptchaKeyPrivate,
        FlashBagInterface $flashBag,
        TranslatorInterface $translator
    ) {
        $this->reCaptchaKeyPrivate = $reCaptchaKeyPrivate;
        $this->flashBag            = $flashBag;
        $this->translator          = $translator;
    }

    public static function getSubscribedEvents()
    {
        return [
            KernelEvents::REQUEST => 'onKernelRequest',
        ];
    }

    public function onKernelRequest(RequestEvent $event)
    {
        if ($event->getRequest()->getMethod() != "POST" && $event->getRequest()->request->count() > 0) {
            return;
        }
        foreach ($event->getRequest()->request->all() as $key => $form) {
           if (($event->getRequest()->request->get('g-recaptcha-response'))) {
                return;
            }
            if (is_array($form)) {
               if (!array_key_exists('g_recaptcha_response', $form) || $form['g_recaptcha_response'] === "") {
                    return;
                }
                $token = $form['g_recaptcha_response'];
                // call curl to POST request
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, "https://www.google.com/recaptcha/api/siteverify");
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt(
                    $ch, CURLOPT_POSTFIELDS, http_build_query(
                        [
                            'secret'   => $this->reCaptchaKeyPrivate,
                            'response' => $token,
                        ]
                    )
                );
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                $response = curl_exec($ch);
                curl_close($ch);
                $arrResponse = json_decode($response, true);

                // verify the response
                if ($arrResponse["success"] == '1' && $arrResponse["score"] >= 0.5) {
                    return;

                } else {
                    $redirectUrl = $event->getRequest()->getUri();
                    $event->getRequest()->setMethod("GET");
                    $this->flashBag->add('error', $this->translator->trans('form.error-recaptcha', [], 'validators'));

                    return new RedirectResponse($redirectUrl);
                }
            }
        }
    }
}
