<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Site;

use CpCreation\VitiCore\Season\Repository\SeasonRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class SeasonController extends AbstractController
{
    private $seasonRepository;

    public function __construct(SeasonRepository $seasonRepository)
    {
        $this->seasonRepository = $seasonRepository;
    }

    /**
     * @return \Symfony\Component\HttpFoundation\Response
     * @throws \Exception
     */
    public function indexAction()
    {
        $seasons = $this->seasonRepository->findBy([],['position' => 'ASC']);

        return $this->render(
            'season.html.twig',
            [
                'classMenu' => 'black',
                'seasons'     => $seasons
            ]
        );
    }
}
