<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Product\Repository;

use CpCreation\VitiCore\Product\Model\ProductPriceGroup;
use CpCreation\VitiCore\Repository\BaseRepository;
use Doctrine\ORM\Query\Expr\Join;
use Doctrine\Persistence\ManagerRegistry;

class ProductPriceGroupRepository extends BaseRepository
{
    /**
     * ProductPriceGroupRepository constructor.
     * @param ManagerRegistry $registry
     * @throws \ReflectionException
     */
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, ProductPriceGroup::class);
    }

    public function findNotSoftDeletable()
    {
        $qb = $this->createQueryBuilder('pg');
        $qb->leftJoin('pg.codes', 'c');
        $qb->add('where',
        $qb->expr()->orX(
            $qb->expr()->eq('pg.byDefault', true),
            $qb->expr()->andX(
                $qb->expr()->isNull('c.deletedAt'),
                $qb->expr()->neq('c.disabled', true)
            )
        ));

        return $qb->getQuery()->getResult();
    }
}
