<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Provider\Carrier;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Filesystem\FileFilesystem;
use CpCreation\VitiCore\Bridge\Symfony\Bundle\Utils\CheckCity;
use CpCreation\VitiCore\Shop\Model\ShippingAuto;
use CpCreation\VitiCore\Shop\Model\ShippingAutoSup;
use CpCreation\VitiCore\Shop\Model\ShippingConfig;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\RequestStack;

class SchenkerProvider implements CarrierProviderInterface
{
    const TYPE = 'DB-Schenker';

    /**
     * @var FileFilesystem
     */
    private $filesystem;

    /**
     * @var EntityManagerInterface
     */
    private $em;

    /**
     * @var CheckCity
     */
    private $checkCity;

    /**
     * @var RequestStack
     */
    private $requestStack;

    public function __construct(RequestStack $requestStack,
        FileFilesystem $filesystem,
        EntityManagerInterface $em,
        CheckCity $checkCity
    ) {
        $this->filesystem   = $filesystem;
        $this->em           = $em;
        $this->checkCity    = $checkCity;
        $this->requestStack = $requestStack;
    }

    /**
     * @param ShippingConfig $config
     * @throws \Doctrine\DBAL\DBALException
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     * @throws \PhpOffice\PhpSpreadsheet\Reader\Exception
     * @throws \PhpOffice\PhpSpreadsheet\Writer\Exception
     */
    public function setData(ShippingConfig $config)
    {
        $files   = $this->requestStack->getCurrentRequest()->files->get('shipping_config');
        $file    = $files['file']['file'];
        $fileSup = $files['fileSup']['file'];
        if ($file) {

            $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
            $reader->setLoadSheetsOnly(["zoning"]);
            $reader->setReadDataOnly(true);
            $spreadsheet = $reader->load($this->filesystem->getAdapter()->getPathPrefix().$config->getFile()->getPath());
            $writer      = new \PhpOffice\PhpSpreadsheet\Writer\Csv($spreadsheet);
            $writer->save($this->filesystem->getAdapter()->getPathPrefix()."schenker-zone.csv");
            $zoneList              = [];
            $shippingQtyCollection = [];
            if (($handle = fopen($this->filesystem->getAdapter()->getPathPrefix()."schenker-zone.csv", "r")) !== false) {

                $classMetaData = $this->em->getClassMetadata(ShippingAuto::class);
                $connection    = $this->em->getConnection();
                $dbPlatform    = $connection->getDatabasePlatform();
                $connection->beginTransaction();
                $connection->query('SET FOREIGN_KEY_CHECKS=0');
                $q = $dbPlatform->getTruncateTableSql($classMetaData->getTableName());
                $connection->executeUpdate($q);
                $connection->query('SET FOREIGN_KEY_CHECKS=1');

                $row = 0;

                while (($data = fgetcsv($handle, 1000, ",")) !== false) {
                    for ($i = 0; $i < count($data); $i++) {
                        if ($data[$i] === "FRANCE") {
                            $zoneNumber                      = substr($data[$i + 2], 2, 1);
                            $departments                     = substr($data[$i + 3], 0, 2);
                            $zoneList[intval($zoneNumber)][] = $departments;
                        }
                    }
                    $row++;
                }
                $this->em->flush();
                fclose($handle);
                unset($handle);
                unset($data);
            }
            //$reader2 = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
            $reader->setLoadSheetsOnly(["transport"]);
            $reader->setReadDataOnly(true);
            $spreadsheet = $reader->load($this->filesystem->getAdapter()->getPathPrefix().$config->getFile()->getPath());
            $writer      = new \PhpOffice\PhpSpreadsheet\Writer\Csv($spreadsheet);
            $writer->save($this->filesystem->getAdapter()->getPathPrefix()."schenker-transport.csv");
            if (($handle2 = fopen($this->filesystem->getAdapter()->getPathPrefix()."schenker-transport.csv", "r")) !== false) {

                $classMetaData = $this->em->getClassMetadata(ShippingAuto::class);
                $connection    = $this->em->getConnection();
                $dbPlatform    = $connection->getDatabasePlatform();
                $connection->beginTransaction();
                $connection->query('SET FOREIGN_KEY_CHECKS=0');
                $q = $dbPlatform->getTruncateTableSql($classMetaData->getTableName());
                $connection->executeUpdate($q);
                $connection->query('SET FOREIGN_KEY_CHECKS=1');
                $shipping = new ShippingAuto();
                $shipping->setCountry('FR');
                $row = 0;

                while (($data = fgetcsv($handle2, 1000)) !== false) {
                    $num = count($data);
                    $row++;
                    for ($i = 0; $i < $num; $i++) {
                        //Ajout des quantitées minimum
                        if ($data[$i] === 'Nombre de bouteilles') {
                            for ($c = 1; $c < $num; $c++) {
                                if ($data[$c] != "") {
                                    $shippingQtyCollection[$c - 2]['of'] = $data[$c]-1;
                                }
                            }
                        }
                        //Ajout des quantitées maximum
                        if (mb_substr($data[$i], 1, 1, 'UTF-8') === 'à') {
                            for ($d = 0; $d < $num; $d++) {
                                if ($data[$d] != "") {
                                    $maxQuantity                         = (int)filter_var($data[$d], FILTER_SANITIZE_NUMBER_INT);
                                    $shippingQtyCollection[$d - 2]['at'] = strval($maxQuantity);
                                }
                            }
                        }
                    }
                    if (is_numeric($data[0]) && explode(" ", $data[1])[0] == "Zone") {
                        for ($e = 2; $e < $num; $e++) {
                            if ($data[$e] != "") {
                                $zone               = explode(" ", $data[1])[1];
                                $departmentsPerZone = $zoneList[$zone];

                                foreach ($departmentsPerZone as $departement) {
                                    $shipping = new ShippingAuto();
                                    $shipping->setCountry('FR');
                                    $shipping->setCounty($departement);
                                    if ($data[$e] > 10) {
                                        $shipping->setQtyOf($shippingQtyCollection[$e - 2]['of']);
                                        $shipping->setQtyAt($shippingQtyCollection[$e - 2]['at']);
                                        $shipping->setPackagePrice(intval(strval($data[$e] * 100)));
                                    } else {
                                        $shipping->setQtyOf($shippingQtyCollection[$e - 2]['of']);
                                        $shipping->setQtyAt($shippingQtyCollection[$e - 2]['at']);
                                        $shipping->setBottlePrice(intval(strval($data[$e] * 100)));
                                    }
                                    $this->em->persist($shipping);
                                }
                            }
                        }
                    }
                }

                $this->em->flush();
                fclose($handle2);
                unset($handle2);
                unset($data);
            }
        }
        if ($fileSup) {
            $spreadsheet = $reader->load($this->filesystem->getAdapter()->getPathPrefix().$config->getFileSup()->getPath());
            $writer      = new \PhpOffice\PhpSpreadsheet\Writer\Csv($spreadsheet);
            $writer->save($this->filesystem->getAdapter()->getPathPrefix()."geodis_sup.csv");

            if (($handle = fopen($this->filesystem->getAdapter()->getPathPrefix()."geodis_sup.csv", "r")) !== false) {

                $classMetaData = $this->em->getClassMetadata(ShippingAutoSup::class);
                $connection    = $this->em->getConnection();
                $dbPlatform    = $connection->getDatabasePlatform();
                $connection->beginTransaction();
                $connection->query('SET FOREIGN_KEY_CHECKS=0');
                $q = $dbPlatform->getTruncateTableSql($classMetaData->getTableName());
                $connection->executeUpdate($q);
                $connection->query('SET FOREIGN_KEY_CHECKS=1');

                $row = 0;
                while (($data = fgetcsv($handle, 1000, ",")) !== false) {
                    if ($row > 0) {
                        if (strlen($data[1]) < 5) {
                            $data[1] = "0".$data[1];
                        }
                        if (strlen($data[3]) < 2) {
                            $data[3] = "0".$data[3];
                        }
                        $shippingSup = new ShippingAutoSup();
                        $shippingSup->setCountry('FR');
                        $shippingSup->setCounty($data[3]);
                        $shippingSup->setPostal($data[1]);
                        $city = trim($data[2]);
                        /*$city = str_replace(" ST ", " SAINT ", trim($data[2]));
                        $city = str_replace("ST ", "SAINT ", $city);
                        $city = $this->checkCity->check($city, $data[3], $data[1]);
                        if ($city) {
                            $shippingSup->setVerification(1);
                        }*/
                        $shippingSup->setOldName(trim($data[2]));
                        $shippingSup->setCity($city);
                        $this->em->persist($shippingSup);

                    }

                    $row++;
                }
                $this->em->flush();
                unset($data);
                fclose($handle);
                unset($handle);
            }
        }
    }

    /**
     * @return string
     */
    public
    function getCarrier(): string
    {
        return static::TYPE;
    }
}
