<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Manager;


use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\SocialNetwork\SocialNetworkNetworkInterface;

class SocialNetworkNetworkManager
{
    private $networks = [] ;

    /**
     * @param SocialNetworkNetworkInterface $network
     */
    public function addMethod(SocialNetworkNetworkInterface $network)
    {
        $this->networks[] = $network;
    }

    /**
     * @param $network
     * @return \ReflectionClass
     * @throws \Exception
     * @throws \ReflectionException
     */
    public function createFormSocialNetworkManager($network)
    {
        foreach ($this->networks as $item)
        {
            if ($item->getNetwork() === $network){

                return new \ReflectionClass($item);
            }
        }

        throw new \Exception("Pas de réseau social configuré pour ce site");

    }
}