<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Client\ConnectCpCreationClient;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

use Symfony\Component\OptionsResolver\OptionsResolver;

class ConnectBasicInstagramUserIdType extends AbstractType
{
    /**
     * @var array
     */
    private $choices;

    public function __construct(ConnectCpCreationClient $client)
    {
        $this->choices = [];
        $result        = $client->get(
            '/api/client_socials', [
                'query' => [
                    "network" => 'basic_instagram',
                ],
            ]
        );
        $data          = json_decode($result->getBody()->getContents(), true);

        $results = $data['hydra:member'];

        foreach ($results as $result) {
            $this->choices[$result['username'].' '.$result['email']] = $result['id'];
        }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'choices' => $this->choices,
            'multiple' => false,
            'attr' => [
                'class' => 'select2'
            ]
        ]);
    }

    public function getParent()
    {
        return ChoiceType::class;
    }
}
