<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Site;

use CpCreation\VitiCore\Locale\Repository\LocaleRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

class VerifyController extends AbstractController
{
    private $localeRepository;

    public function __construct(LocaleRepository $localeRepository)
    {
        $this->localeRepository = $localeRepository;
    }

    /**
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction()
    {
        $locales = $this->localeRepository->findAll();

        return $this->render(
            'verify.html.twig',
            [
                'locales' => $locales,
            ]
        );
    }
}
