<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Site;

use CpCreation\VitiCore\Gite\Model\Gite;
use CpCreation\VitiCore\Gite\Model\Room;
use CpCreation\VitiCore\Gite\Repository\GiteRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Component\Routing\Annotation\Route;

class CottageController extends AbstractController
{
    private $cottageRepository;

    public function __construct(GiteRepository $cottageRepository)
    {
        $this->cottageRepository = $cottageRepository;
    }

    /**
     * @param Gite $gite
     *
     * @ParamConverter("gite", converter="translation_converter")
     * @return \Symfony\Component\HttpFoundation\RedirectResponse|\Symfony\Component\HttpFoundation\Response
     */
    public function indexAction(Gite $gite)
    {
        return $this->render(
            'cottage.html.twig',
            [
                'classMenu' => 'black',
                'cottage'   => $gite,
            ]
        );
    }

    /**
     * @param Room $room
     *
     * @Route({
     *     "fr": "/gite/chambre/{slug}",
     *     "en": "/gite/room/{slug}"
     * }, name="giteItem")
     * @ParamConverter("room", converter="translation_converter")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse|\Symfony\Component\HttpFoundation\Response
     */
    public function itemAction(Room $room)
    {
        $cottages = $cottages = $this->getDoctrine()->getRepository(Gite::class)->findAll();
        $prevRoom = $this->cottageRepository->findOneBy(['position' => $room->getPosition() - 1]);
        $nextRoom = $this->cottageRepository->findOneBy(['position' => $room->getPosition() + 1]);

        return $this->render(
            'cottageItem.html.twig',
            [
                'cottages' => $cottages,
                'room'     => $room,
                'prevItem' => $prevRoom,
                'nextItem' => $nextRoom,
            ]
        );
    }
}
