<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;

use CpCreation\VitiCore\Shop\Repository\ShippingAutoRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * @Security("is_granted('ROLE_ADMIN')")
 * Class ShippingAutoController
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 * @Route("/shipping-auto-price")
 */
class ShippingAutoController extends AbstractController
{
    private $shippingAutoRepository;

    public function __construct(ShippingAutoRepository $shippingAutoRepository)
    {
        $this->shippingAutoRepository = $shippingAutoRepository;
    }

    /**
     * @route("", name="admin_shipping_auto")
     * @Template("@CpCreationVitiCore/admin/shipping/auto/index.html.twig")
     */
    public function indexAction()
    {
        $prices = $this->shippingAutoRepository->findOrder();

        return [
            "items" => $prices,
        ];
    }
}
