<?php

namespace CpCreation\VitiCore\Bridge\Doctrine\Filter;

use CpCreation\VitiCore\Behavior\IsSoftDeletable;
use CpCreation\VitiCore\Cart\Model\PaymentMethod;
use CpCreation\VitiCore\Product\Model\ProductVariant;
use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\ORM\Query\Filter\SQLFilter;
use Symfony\Component\Security\Core\Security;

/**
 * @author Colinet Julien
 */
final class SoftDeletableFilter extends SQLFilter
{
    /**
     * @param ClassMetadata $targetEntity
     * @param string        $targetTableAlias
     * @return string
     */
    public function addFilterConstraint(ClassMetadata $targetEntity, $targetTableAlias)
    {

        foreach ($targetEntity->getReflectionClass()->getInterfaces() as $interface) {
            if($interface->getName() === IsSoftDeletable::class) {
                if ($targetEntity->getName() === ProductVariant::class)
                {
                    return "{$targetTableAlias}.deleted_at IS NULL";
                }
            }
        }

        return '';
    }
}
