<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\SocialNetwork\Model;

use ApiPlatform\Core\Annotation\ApiProperty;
use CpCreation\VitiCore\Behavior\HasTimestamp;
use CpCreation\VitiCore\Behavior\Impl\Timestamp;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;

/**
 * Class SocialNetworkNew
 *
 * @ORM\Entity(repositoryClass="CpCreation\VitiCore\SocialNetwork\Repository\SocialNetworkNewRepository")
 * @ORM\Table(name="socialnetwork_socialnetworkNew")
 * @ORM\HasLifecycleCallbacks()
 */
class SocialNetworkNew implements HasTimestamp
{
    use Timestamp;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;

    /**
     * Id de connectId
     * @ORM\Column(type="string")
     * @var string
     */
    private $connectId;

    /**
     * @ORM\Column(type="string", nullable=true)
     * @var string
     */
    private $username;

    /**
     * Le nom du réseau social
     * @ORM\Column(type="string")
     * @var string
     */
    private $network;

    /**
     * @var array
     *
     * @ORM\Column(type="json")
     */
    private $data;

    public function __construct()
    {
        $this->id   = Uuid::uuid4();
        $this->data = [];
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getConnectId(): string
    {
        return $this->connectId;
    }

    /**
     * @param string $connectId
     */
    public function setConnectId(string $connectId): void
    {
        $this->connectId = $connectId;
    }

    /**
     * @return string
     */
    public function getUsername(): string
    {
        return $this->username;
    }

    /**
     * @param string $username
     */
    public function setUsername(?string $username): void
    {
        $this->username = $username;
    }

    /**
     * @return string
     */
    public function getNetwork(): string
    {
        return $this->network;
    }

    /**
     * @param string $network
     */
    public function setNetwork(string $network): void
    {
        $this->network = $network;
    }

    /**
     * @return array
     */
    public function getData(): array
    {
        return $this->data;
    }

    /**
     * @param array $data
     */
    public function setData(array $data): void
    {
        $this->data = $data;
    }
}
