<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Repository;

use CpCreation\VitiCore\Repository\BaseRepository;
use CpCreation\VitiCore\Shop\Model\ShippingZone;
use CpCreation\VitiCore\Shop\Model\ShopConfigMultiple;
use Doctrine\ORM\Query\Expr\Join;
use Doctrine\Persistence\ManagerRegistry;

class ShopConfigMultipleRepository extends BaseRepository
{
    /**
     * ShopConfigRepository constructor.
     * @param ManagerRegistry $registry
     * @throws \ReflectionException
     */
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, ShopConfigMultiple::class);
    }

    /**
     * @return mixed
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function findByQuantityAndByTypeAndByZone(int $qty, string $type, ShippingZone $zone)
    {
        $qb = $this
            ->createQueryBuilder('p')
            ->innerJoin('p.types', 't')
            ->innerJoin('t.translations', 'tr', Join::WITH, 'tr.slug = :type')
            ->innerJoin('p.zones', 'z', Join::WITH, 'z.id = :zone')
            ->andwhere('p.qtyOf < :qty')
            ->andwhere('p.qtyAt >= :qty')
            ->setParameter('qty', $qty)
            ->setParameter('type', $type)
            ->setParameter('zone', $zone->getId()->toString())
            ->getQuery()
            ->setMaxResults(1)
            ->getOneOrNullResult();

        return $qb;
    }
}
