<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Shop\Model\Translation;

use CpCreation\VitiCore\Behavior\Impl\Translation;
use Doctrine\ORM\Mapping as ORM;
use Knp\DoctrineBehaviors\Contract\Entity\TranslationInterface;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;

/**
 * Class ShopConfigTranslation
 *
 * @ORM\Entity()
 * @ORM\Table(name="shop_config_translation")
 * @ORM\HasLifecycleCallbacks()
 */
class ShopConfigTranslation implements TranslationInterface
{
    use Translation;

    /**
     * @ORM\Id()
     * @ORM\Column(type="uuid")
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var UuidInterface
     */
    private $id;
    
    /**
     * @ORM\Column(type="string", nullable=true)
     *
     * @var string|null
     */
    private $favoriteCatName;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string|null
     */
    private $vacation;

    public function __construct()
    {
        $this->id       = Uuid::uuid4();
    }

    /**
     * @return UuidInterface
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }
    
    /**
     * @return string|null
     */
    public function getFavoriteCatName(): ?string
    {
        return $this->favoriteCatName;
    }

    /**
     * @param string|null $favoriteCatName
     */
    public function setFavoriteCatName(?string $favoriteCatName): void
    {
        $this->favoriteCatName = $favoriteCatName;
    }

    /**
     * @return string|null
     */
    public function getVacation(): ?string
    {
        return $this->vacation;
    }

    /**
     * @param string|null $vacation
     */
    public function setVacation(?string $vacation): void
    {
        $this->vacation = $vacation;
    }
}
