<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Product\Repository;

use CpCreation\VitiCore\Product\Model\Product;
use CpCreation\VitiCore\Product\Model\ProductVariant;
use CpCreation\VitiCore\Repository\BaseRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Query\Expr\Join;
use Doctrine\Persistence\ManagerRegistry;

class ProductVariantRepository extends BaseRepository
{
    /**
     * ProductVariantRepository constructor.
     * @param ManagerRegistry $registry
     * @throws \ReflectionException
     */
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, ProductVariant::class);
    }

    public function findAllPublishQuery()
    {
        $qb = $this->createQueryBuilder('pv')
                   ->innerJoin('pv.product', 'p')
                   ->andWhere('p.disabled = FALSE')
                   ->andWhere('pv.unPublished = FALSE')
                   ->andWhere('pv.deletedAt is NULL')
                   ->orderBy('p.position', 'ASC');

        return $qb;

    }

    public function getVariantsByProduct(Product $product): Collection
    {
        $qb = $this->createQueryBuilder('variant')
            ->innerJoin('variant.product', 'product', Join::WITH, 'product.id = :id')
            ->andWhere('variant.deletedAt is NULL')
            ->setParameter('id', $product->getId());

        return new ArrayCollection($qb->getQuery()->getResult());
    }
}
