<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Utils;

use CpCreation\VitiCore\Product\Model\Product;
use CpCreation\VitiCore\Product\Model\ProductPrice;
use CpCreation\VitiCore\Product\Model\ProductVariant;
use CpCreation\VitiCore\Product\Repository\ProductPriceCodeRepository;
use CpCreation\VitiCore\Product\Repository\ProductPriceGroupRepository;
use CpCreation\VitiCore\Product\Repository\ProductRepository;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\Routing\RouterInterface;

class PriceGroupWithCookie
{
    private $productRepository;
    private $productPriceGroupRepository;
    private $productPriceCodeRepository;
    private $request;
    private $router;

    public function __construct(ProductRepository           $productRepository,
                                ProductPriceGroupRepository $productPriceGroupRepository,
                                ProductPriceCodeRepository  $productPriceCodeRepository,
                                RouterInterface             $router,
                                RequestStack                $request
    )
    {
        $this->productPriceGroupRepository = $productPriceGroupRepository;
        $this->productRepository = $productRepository;
        $this->productPriceCodeRepository = $productPriceCodeRepository;
        $this->request = $request;
        $this->router = $router;
    }

    public function findAllPublish()
    {
        $priceGroupId = $this->request->getSession()->get("groupPrice", null);
        $products = $this->productRepository->findOnlyShop($priceGroupId);
        /** @var Product $product */
        foreach ($products as $product) {
            /** @var ProductVariant $variant */
            foreach ($product->getVariants() as $variant) {
                /** @var ProductPrice $price */
                foreach ($variant->getPrices() as $price) {
                    if ($price->getGroup()->getId()->toString() === $priceGroupId) {
                        $variant->setPrice($price->getPrice());
                        $variant->setPriceDiscount($price->getPriceDiscount());
                    }
                }
            }
        }

        return $products;
    }
}
