<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\EventListener;

use CpCreation\VitiCore\Product\Repository\ProductPriceGroupRepository;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpKernel\Event\RequestEvent;
use Symfony\Component\HttpKernel\KernelEvents;

class GroupListener implements EventSubscriberInterface
{
    private $request;
    private $productPriceGroupRepository;

    public function __construct(RequestStack $requestStack, ProductPriceGroupRepository $productPriceGroupRepository)
    {
        $this->request                    = $requestStack;
        $this->productPriceGroupRepository = $productPriceGroupRepository;
    }

    public static function getSubscribedEvents()
    {
        return [
            KernelEvents::REQUEST => [['onKernelRequest', 10]],
        ];
    }

    public function onKernelRequest(RequestEvent $event)
    {
        if (!$event->isMainRequest()) {
            return;
        }
        if (!$this->request->getSession()->get("groupPrice")) {
            $defaultGroup = $this->productPriceGroupRepository->findOneBy(["byDefault" => true]);
            if ($defaultGroup) {
                $this->request->getSession()->set("groupPrice", $defaultGroup->getId()->toString());
                $this->request->getSession()->set("groupByDefault", true);
                $this->request->getSession()->set("codePrice", null);
            }
        }
    }
}
