<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Site;

use CpCreation\VitiCore\Gite\Repository\GiteRepository;
use CpCreation\VitiCore\Newsletter\Repository\NewsletterRepository;
use CpCreation\VitiCore\Popup\Repository\PopupRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use CpCreation\VitiCore\Contact\Repository\ContactRepository;
use CpCreation\VitiCore\Contact\Repository\LabelRepository;

class HomepageController extends AbstractController
{

    private $popupRepository;
    private $newsletterRepository;
    private $giteRepository;
    private $contactRepository;
    private $labelRepository;
    private $request;

    public function __construct(PopupRepository $popupRepository,
        NewsletterRepository $newsletterRepository,
        GiteRepository $giteRepository,
        RequestStack $requestStack,
        ContactRepository $contactRepository,
        LabelRepository $labelRepository
    ) {
        $this->popupRepository      = $popupRepository;
        $this->newsletterRepository = $newsletterRepository;
        $this->giteRepository       = $giteRepository;
        $this->request             = $requestStack;
        $this->contactRepository    = $contactRepository;
        $this->labelRepository      = $labelRepository;

    }

    /**
     * @return \Symfony\Component\HttpFoundation\Response
     * @throws \Doctrine\ORM\NonUniqueResultException
     */
    public function indexAction()
    {
        $popup      = $this->popupRepository->findOneOrNull();
        $newsletter = $this->newsletterRepository->findLastNewsletter();
        $cottages   = $this->giteRepository->findAll();
        $subMenu    = null;
        $contact    = $this->contactRepository->findOne();
        $labels     = $this->labelRepository->findBy([], ['position' => 'ASC']);

        if ($newsletter) {
            $subMenu = true;
        }

        return $this->render(
            'homepage.html.twig',
            [
                'popup'      => $popup,
                'newsletter' => $newsletter,
                'subMenu'    => $subMenu,
                'cottages'   => $cottages,
                'contact'    => $contact,
                'labels'     => $labels,
            ]
        );
    }
}
