<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\UserType;
use CpCreation\VitiCore\User\Model\User;
use CpCreation\VitiCore\User\Repository\UserRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;

/**
 * @Security("is_granted('ROLE_ADMIN')")
 * Class UserController
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 * @Route("/users")
 */
class UserController extends AbstractController
{
    private $userRepository;

    public function __construct(UserRepository $userRepository)
    {
        $this->userRepository =  $userRepository;
    }
    /**
     * @route("", name="admin_user")
     */
    public function listAllUsers()
    {
        $users = $this->userRepository->findAll();

        return $this->render('admin/user/index.html.twig', [
            "items" => $users,
        ]);
    }

    /**
     * @param Request $request
     * @Route("/new", name="admin_user_new")
     * @Template("@CpCreationVitiCore/admin/user/new.html.twig")
     *
     * 
     */
    public function newAction(Request $request)
    {

        $form = $this->createForm(UserType::class, null, ['validation_groups' => ['registration','Default']]);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var User $data */
            $data = $form->getData();
            $this->userRepository->save($data);
            $this->addFlash('alert-success', 'L\'utilisateur '.$data->getUsername().' a été ajouté avec succès');

            return $this->redirectToRoute('admin_user');
        }

        return $this->render('admin/user/new.html.twig', [
            "form" => $form->createView(),
        ]);

    }

    /**
     * @param User   $user
     * @param Request $request
     * @Route("/{id}/edit", name="admin_user_edit")
     * @Template("@CpCreationVitiCore/admin/user/edit.html.twig")
     *
     * 
     */
    public function editAction(User $user, Request $request)
    {
        $form = $this->createForm(UserType::class, $user);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var User $data */
            $data = $form->getData();
            $data->setUpdatedAt(new \DateTime());
            $this->userRepository->save($data);
            $this->addFlash('alert-success', 'L\'utilisateur '.$data->getUsername().' a été modifié avec succès');

            return $this->redirectToRoute('admin_user');
        }

        return $this->render('admin/user/edit.html.twig', [
            "item" => $user,
            "form" => $form->createView(),
        ]);

    }

    /**
     * @param User $user
     * @Route("/{id}/delete", name="admin_user_delete")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteAction(User $user)
    {
        $this->userRepository->delete($user);
        $this->addFlash('alert-success', 'L\'utilisateur '.$user->getUsername().' a été supprimé avec succès.');

        return $this->redirectToRoute('admin_user');
    }
}
