<?php
/**
 * @author Colinet Julien
 */

namespace CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin;

use CpCreation\VitiCore\Bridge\Symfony\Bundle\Form\Admin\ProductDegressiveType;
use CpCreation\VitiCore\Product\Model\ProductDegressive;
use CpCreation\VitiCore\Product\Repository\ProductDegressiveRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * @Security("is_granted('ROLE_ADMIN') or is_granted('ROLE_DEGRESSIVE')")
 * Class ProductDegressiveController
 * @package CpCreation\VitiCore\Bridge\Symfony\Bundle\Controller\Admin
 * @Route("/product-degressive")
 */
class ProductDegressiveController extends AbstractController
{
    private $productDegressiveRepository;

    public function __construct(ProductDegressiveRepository $productDegressiveRepository)
    {
        $this->productDegressiveRepository = $productDegressiveRepository;
    }

    /**
     * @route("", name="admin_product_degressive")
     */
    public function indexAction()
    {
        $discounts = $this->productDegressiveRepository->findOrder();

        return $this->render('admin/product/degressive/index.html.twig', [
            "items" => $discounts
        ]);
    }


    /**
     * @param Request $request
     * @Route("/new", name="admin_product_degressive_new")
     *
     * 
     */
    public function newAction(Request $request)
    {

        $form = $this->createForm(ProductDegressiveType::class);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var ProductDegressive $data */
            $data = $form->getData();
            $this->productDegressiveRepository->save($data);
            $this->addFlash('alert-success', 'La dégressivité a été ajouté avec succès');

            return $this->redirectToRoute('admin_product_degressive');

        }

        return $this->render('admin/product/degressive/new.html.twig', [
            "form" => $form->createView(),
        ]);

    }

    /**
     * @param ProductDegressive $degressive
     * @param Request $request
     * @Route("/{id}/edit", name="admin_product_degressive_edit")
     *
     * 
     */
    public function editAction(ProductDegressive $degressive, Request $request)
    {
        $form = $this->createForm(ProductDegressiveType::class, $degressive);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            /** @var ProductDegressive $data */
            $data = $form->getData();
            $this->productDegressiveRepository->save($data);
            $this->addFlash('alert-success', 'La dégressivité a été modifié avec succès');

            return $this->redirectToRoute('admin_product_degressive');

        }

        return $this->render('admin/product/degressive/edit.html.twig', [
            "item" => $degressive,
            "form" => $form->createView(),
        ]);
    }

    /**
     * @param ProductDegressive $degressive
     * @Route("/{id}/delete", name="admin_product_degressive_delete")
     *
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteAction(ProductDegressive $degressive)
    {
        $this->productDegressiveRepository->delete($degressive);
        $this->addFlash('alert-success', 'La dégressivité a été supprimé avec succès.');

        return $this->redirectToRoute('admin_product_degressive');
    }
}
